function JSetPicker(owner, parent, name, dataset, field, rect, tab, tabStop, tabIndex)
{
	var self = this,
		_disposed = false,
		_items = [];

	this.initialize(owner, parent, name, null, null, rect, null, field, dataset, tab);

	this.rolled   = isRolled;
	this.value    = null;
	this.methods  = (cmRender | cmLoad | cmSave);
	this.dirty    = false;
	this.orgValue = null;
	this.inplace  = false;
	this.tabStop  = tabStop;
	this.tabIndex = (tabIndex == null) ? -1 : parseInt(tabIndex);

	this.owner.addImage("drop-down",    "drop-down.gif",    "controls");
	this.owner.addImage("checkbox-off", "checkbox-off.gif", "controls");
	this.owner.addImage("checkbox-on",  "checkbox-on.gif",  "controls");

	this.render      = render;
	this.load        = load;
	this.dispose     = dispose;
	this.save        = save;
	this.select      = select;
	this.keyHandler  = keyHandler;
	this.roll        = roll;

	this.bind_setValue = bind_setValue;

	function render(fs)
	{
		self.rect.width -= 17;

		var imgrect = utils.format("left: %1px; top: %2px; height: %3px", self.rect.left + self.rect.width, self.rect.top + 2, self.rect.height - 4);

		fs.append('<nobr><input class="enumpicker" type="text" id="' + self.name + '" style="background-color: gainsboro; ' + self.rect + '">');
		fs.append('<img id="' + self.name + '_img" src="' + self.owner.images["drop-down"].src + '" style="cursor: hand; position: absolute; ' + imgrect + '">');
		self.rect.width += 17;

		fs.append('<div class="picker" id="' + self.name + '_picker" style="' + utils.format("display: none; left: %1px; top: %2px; width: %3px", self.rect.left, self.rect.top + self.rect.height, self.rect.width) + '">');
		fs.append('<table width="100%" id="' + self.name + '_list">');

		self.dataset.fields[self.field].items.forIn( function (item, i)
		{
			fs.append('<tr><td class="picker_item" width="100%" id="' + self.name + '_item_' + i + '">');

			fs.append('<img align="absmiddle" id="' + self.name + '_item_' + i + '_img" src="' + self.owner.images["checkbox-off"].src + '">');

			fs.append(item); //self.dataset.fields[self.field].items[i]);
			fs.append('</td></tr>');
		}, self);

		fs.append('</table>');
		fs.append('</div></nobr>');
	}

	function load()
	{
		var elem = self.$$(),
			picker = self.$$("_picker"),
			style = elem.style,
			img = self.$$('_img'),
			imgStyle = null,
			corr = 0;

		if (img != null)
		  imgStyle = img.style;

		elem.value = self.dataset.getText(self.field);
		elem.tabIndex = self.tabIndex;
		elem.onkeydown= self.keyHandler;

		var form = self.getForm();
		if ((form != null) && (form.setActiveControl))
			elem.onfocus = function() {form.setActiveControl(self); };

		img.onclick = self.roll;
		corr = 17;

		self.dataset.fields[self.field].items.forIn( function (item, i)
		{
			self.$$('_item_' + i + '_img').onclick = getClickFunc(i);
			_items.push(i);
		}, self);

		var doc = self.owner.getDocument();
		doc.body.appendChild(picker);	// move it to body so that it may overlap other elements

		if (self.inplace)
		{
			var prnt = elem.parentNode.parentNode;
			var pos = utils.getElementBox(prnt, doc);

			elem.className = 'editInplace';
			if (img != null)
				img.className = 'enumpickerImgInplace';

			if (pos.height != 0)
			{
				style.height = pos.height - 2;
				style.fontSize = pos.height - 8;
			}
			if (pos.width != 0)
				style.width = pos.width - corr - 4;

			style.textAlign = prnt.style.textAlign;
			prnt.style.textAlign = '';

		}
		else
		if (self.rect.isRelative())
		{
			if (img != null)
				img.className = 'enumpickerImgRelative';
			elem.className = 'enumpicker enumpickerRelative';

			style.height = self.rect.height;
			style.width = self.rect.width; // - corr;
		}
		else
		{
			style.position = 'absolute';
			style.top = self.rect.top;
			style.left = self.rect.left;
			style.height = self.rect.height;
			style.width = self.rect.width - corr;

			if (imgStyle != null)
			{
				imgStyle.position = 'absolute';
				imgStyle.left = self.rect.left + self.rect.width - corr;
				imgStyle.top = self.rect.top + 2;
				imgStyle.height = self.rect.height - 4;
			}
		}

/*		
		if (readOnly)
		{
			elem.readOnly = true;
			elem.className += ' readOnly';
		}
*/

		checkControlState();

		self.value = self.dataset.get(self.field);
		self.select();
		self.orgValue = self.value;

		if ((self.dataset != null) && (! utils.isEmpty(self.field)))
			self.dataset.bindingManager.bind(self, '', self.field);
	}

	function getClickFunc(idx)
	{
		return function(event) { self.select(event, idx); };
	}

	function checkControlState(record)
	{
		if (!record)
			record = self.dataset.getCurrentRecord();

		var elem = self.$$();
		var img = self.$$('_img');

		if ((record) && (record.isReadOnly(self.field)))
		{
			elem.readOnly = true;
			elem.className += ' readOnly';

			if (img)
				img.style.display = 'none';
		}
		else
		{
			elem.readOnly = true;
			elem.className = elem.className.replace(' readOnly', '');

			if (img)
				img.style.display = '';
		}

		var required = (record) && (record.isRequired(self.field));
		if (required)
		{
			if (elem.className.indexOf('requiredField') == -1)
				elem.className += ' requiredField';
		}
		else
			elem.className = elem.className.replace(' requiredField', '');
	}

	function bind_setValue(prop, field, record)
	{
		if (self.$$() == null)
			return;

		if ((record) && (record.isNoData(field)))
			record = null;

		checkControlState(record);

		if ((record == null) || (record.dataset == null))
		{
			self.value = null;
		}
		else
		{
			self.value = self.dataset.get(self.field);
		}

		self.select();
}

	function save()
	{
		self.dataset.set(self.field, self.value);

		if (self.value != self.orgValue)
			self.dirty = true;
		else
			self.dirty = false;
	}

	function select(event, item)
	{
		utils.cancelEvent(event);

		if (!self.dataset.isReadOnly(self.field))
		{
			//var tbody = self.$$("_list");
			var image = null;

			if (item != null)
				self.value ^= item;

			self.dataset.fields[self.field].items.forIn( function (item, i)
			{
				image = (((self.value & i) == i) ? "checkbox-on" : "checkbox-off");
				//        tbody.getElementsByTagName("*")[self.name + "_item_" + i + "_img"].src = self.owner.images[image].src;
				self.$$("_item_" + i + "_img").src = self.owner.images[image].src;
			}, self);

			self.save();
			self.$$().value = self.dataset.getText(self.field);
		}
		else
		{
			if (self.rolled() == true)
				self.roll();
		}
	}

	function keyHandler(event)
	{
		if (!event)
			event = window.event;

		if ((!event.ctrlKey && utils.inList(event.keyCode, 9, 35, 36, 37, 39)) || (event.ctrlKey && utils.inList(event.keyCode, 67, 86)))
		{
			if (browser.isIE)
				event.returnValue = true;
		}
		else
		{
			if (browser.isIE)
				event.returnValue = false;
			else
			if (event.preventDefault)
				event.preventDefault();
		}
	}

	function isRolled()
	{
		return utils.getStyle(self.$$("_picker"), 'display') != 'none';
	}

	function roll(event)
	{
//		self.onrolling.raise(self, !self.rolled());

		var picker = self.$$("_picker"),
			style = picker.style;

		if (!self.rolled())
		{
	//		if (_itemsCount == 0)
	//			return;

			if (event == null)
				event = self.owner.getWindow().event;
			self.owner.registerPopup(picker.id, true, event);

			var pos = utils.getElementPosition(self.name, self.owner.getDocument());

			var border = parseInt(utils.getStyle(self.$$(), 'borderLeftWidth'));
			if (isNaN(border))
				border = 0;

			style.left = pos.left + border;
			style.top = pos.top + self.$$().offsetHeight + border;

			style.zIndex  = utils.getParentZIndex(self.$$()) + 1000;
			style.width   = self.$$().offsetWidth + 17;
			style.display = 'block';

			if (parseInt(picker.offsetHeight) > 101)
				style.height = 101;

			style.backgroundColor = (self.dataset.isReadOnly(self.field) == false) ? "" : "gainsboro";
		}
		else
		{
			picker.className = 'picker';
			style.display = 'none';
		}
	}

	function dispose()
	{
		if (_disposed)
			return;

		if ((self.dataset != null) && (self.dataset.bindingManager != null))
			self.dataset.bindingManager.unbind(self);
		
		self.$$().onkeydown = null;

		if (self.$$('_img') != null)
			self.$$('_img').onclick = null;

		_items.forEach( function (i)
		{
			self.$$('_item_' + i + '_img').onclick = null;
		}, self);

		if (self.rolled())
			self.roll();

		var picker = self.$$("_picker");
		if (picker != null)
		{
			picker.style.display = 'none';
			if (picker.parentNode != null)
				picker.parentNode.removeChild(picker);
		}

		self.base.dispose.call(self);
		_disposed = true;
	}


}
JSetPicker.inheritsFrom(ControlBase);

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();